<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\AuthType;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    'none' => NoneAuthType::class,
    'basic' => BasicAuthType::class,
    'jwt' => JwtAuthType::class,
])]
abstract class AuthType implements JsonSerializable
{
    use SerializableTrait;

    /**
     * @return array<string, string>
     */
    abstract public function prepareHeaders(): array;
}