<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\AuthType;

use idoit\Module\SyneticsFlows\Validation\Required;

class JwtAuthType extends AuthType
{
    public function __construct(
        #[Required]
        private ?string $jwtToken,
    )
    {
    }

    public function getJwtToken(): ?string
    {
        return $this->jwtToken;
    }

    public function prepareHeaders(): array
    {
        return [
            'Authorization' => 'Bearer ' . $this->jwtToken,
        ];
    }
}