<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class CmdbChange implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private ?string $attribute,
        private mixed $value,
    )
    {
    }

    public function getAttribute(): ?string
    {
        return $this->attribute;
    }

    public function getValue(): mixed
    {
        return $this->value;
    }
}