<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CategoryChange;
use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Validation\Required;

class CreateObjectAction extends ActionType
{
    public function __construct(
        #[Required]
        private ?string $objectType = null,
        #[Required]
        private ?string $title = null,
        #[ArrayFormat(CategoryChange::class)]
        private array $changes = [],
    )
    {
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function getObjectType(): ?string
    {
        return $this->objectType;
    }

    /**
     * @return CategoryChange[]
     */
    public function getChanges(): array
    {
        return $this->changes;
    }
}