<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Argument;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;

class CollectionArgumentConverter implements ArgumentConverter
{
    /**
     * @param ArgumentConverter[] $converters
     */
    public function __construct(private array $converters)
    {
    }

    public function convert(Command $command, InputArgument $argument): ?IdoitCliArgument
    {
        foreach ($this->converters as $converter) {
            if (!$converter->supports($command, $argument)) {
                continue;
            }
            return $converter->convert($command, $argument);
        }

        return null;
    }

    public function supports(Command $command, InputArgument $argument): bool
    {
        foreach ($this->converters as $converter) {
            if ($converter->supports($command, $argument)) {
                return true;
            }
        }

        return false;
    }
}