<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\JDisc;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\DataSource;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_jdisc_dao;

class JDiscServerDataSource implements DataSource
{
    /**
     * @param isys_jdisc_dao $dao
     */
    public function __construct(private isys_jdisc_dao $dao)
    {
    }

    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     */
    public function getValues(array $parameters): array
    {
        $result = $this->dao->get_jdisc_servers();
        if (!$result instanceof \isys_component_dao_result) {
            return [];
        }

        $values = [];
        while ($row = $result->get_row()) {
            $values[] = new SelectOptionValue(
                "{$row['isys_jdisc_db__id']}",
                "{$row['isys_jdisc_db__host']}:{$row['isys_jdisc_db__database']}"
            );
        }

        return array_values($values);
    }
}