<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\Notification;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource\DataSource;
use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use isys_notifications_dao;

class NotificationIdDataSource implements DataSource
{
    /**
     * @param isys_notifications_dao $dao
     */
    public function __construct(private isys_notifications_dao $dao)
    {
    }

    /**
     * @param array $parameters
     * @return array|SelectOptionValue[]
     */
    public function getValues(array $parameters): array
    {
        $values = array_map(
            fn (mixed $data) => new SelectOptionValue(
                "{$data['id']}",
                "{$data['id']}: {$data['title']}"
            ),
            $this->dao->get_notifications(),
        );
        return array_values($values);
    }
}