<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputOption;

class OverwriteConverter implements OptionConverter
{
    /**
     * @var array<string, array<string, IdoitCliOption>>
     */
    private array $overwriteCommandOptions = [];

    public function overwriteOption(string $command, IdoitCliOption $option): self
    {
        if (!isset($this->overwriteCommandOptions[$command])) {
            $this->overwriteCommandOptions[$command] = [];
        }
        $this->overwriteCommandOptions[$command][$option->getName()] = $option;

        return $this;
    }

    public function convert(Command $command, InputOption $option): ?IdoitCliOption
    {
        return $this->overwriteCommandOptions[$command->getName()][$option->getName()] ?? null;
    }

    public function supports(Command $command, InputOption $option): bool
    {
        return isset($this->overwriteCommandOptions[$command->getName()][$option->getName()]);
    }
}