<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

class RankObjectResult extends ExecutionResult
{
    /**
     * @param array|null $objectIds
     * @param string|null $status
     */
    public function __construct(private ?array $objectIds = null, private ?string $status = null)
    {
    }

    /**
     * @return array|null
     */
    public function getObjectIds(): ?array
    {
        return $this->objectIds;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return "Objects ranked.";
    }
}
