<?php

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

use idoit\Module\SyneticsFlows\Validation\Required;

class SendEmailResult extends ExecutionResult
{
    public function __construct(
        #[Required]
        private ?string $subject = null,
        #[Required]
        private ?string $body = null,
        #[Required]
        private ?array $recipients = null
    )
    {
    }

    /**
     * @return string|null
     */
    public function getBody(): ?string
    {
        return $this->body;
    }

    /**
     * @return array|null
     */
    public function getRecipients(): ?array
    {
        return $this->recipients;
    }

    /**
     * @return string|null
     */
    public function getSubject(): ?string
    {
        return $this->subject;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return 'E-mail ' . $this->subject . ' send';
    }
}
