<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

class UpdateDataResult extends ExecutionResult
{
    /**
     * @param array|null $objectIds
     * @param array|null $changes
     */
    public function __construct(private ?array $objectIds = null, private ?array $changes = null)
    {
    }

    /**
     * @return array|null
     */
    public function getObjectIds(): ?array
    {
        return $this->objectIds;
    }

    public function getChanges(): ?array
    {
        return $this->changes;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return "Objects updated.";
    }
}
