<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;

class ValidationErrorResult extends ExecutionResult implements ErrorExecutionInterface
{
    /**
     * @param ValidationError[] $validationErrors
     */
    public function __construct(
        #[ArrayFormat(ValidationError::class)]
        private array $validationErrors = []
    )
    {
    }

    /**
     * @return ValidationError[]
     */
    public function getValidationErrors(): array
    {
        return $this->validationErrors;
    }

    public function __toString(): string
    {
        return 'Validation errors occurred.';
    }
}
