<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\PerformExecution;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CategoryChange;

class ValidateCategoryChanges extends AbstractCategoryChanges
{
    /**
     * @param int            $objectId
     * @param CategoryChange $change
     *
     * @return mixed
     */
    public function validateChange(int $objectId, CategoryChange $change): mixed
    {
        if (!($dao = $this->getDaoOfCategory($change))) {
            return false;
        }

        $data = $this->preparePropertiesData($change->getChanges());

        // Validate method expects this kind of structure ['title' => 'xyz', ...]
        array_walk($data, fn(&$item) => $item = $item[C__DATA__VALUE] ?? null);

        return $dao->validate($data);
    }
}
