<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType\ExecutionEnd;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\Serializer;
use JsonSerializable;

#[Discriminator([
    'on-date' => DateExecutionEnd::class,
    'on-count' => ExecutionCountEnd::class
])]
class ExecutionEnd implements JsonSerializable
{
    /**
     * @return array
     */
    function jsonSerialize(): array
    {
        return Serializer::toJson($this);
    }
}