<?php

namespace idoit\Module\SyneticsFlows;

class Blocked
{
    public const GLOBAL_CATEGORIES = [
        'C__CATG__CUSTOM_FIELDS',
        'C__CATG__DATABASE_ASSIGNMENT',
        'C__CATG__FILE',
        'C__CATG__IDENTIFIER',
        'C__CATG__IMAGE',
        'C__CATG__IMAGES',
        'C__CATG__LAST_LOGIN_USER',
        'C__CATG__LOGBOOK',
        'C__CATG__RELATION',
        'C__CATG__OVERVIEW',
        'C__CATG__VRRP_MEMBER',
    ];

    public const SPECIFIC_CATEGORIES = [
        'C__CATS__PDU_OVERVIEW',
        'C__CATS__FILE',
        'C__CATS__FILE_VERSIONS',
        'C__CATS__FILE_ACTUAL',
        'C__CATS__FILE_OBJECTS',
        'C__CATS__RELATION_DETAILS',
        'C__CATS__PARALLEL_RELATION',
        'C__CATS__PDU_BRANCH',
        'C__CATS__CHASSIS',
        'C__CATS__CHASSIS_CABLING',
        'C__CATS__CHASSIS_DEVICES',
        'C__CATS__CHASSIS_VIEW',
        'C__CATS__DATABASE_SCHEMA',
        'C__CATS__DATABASE_ACCESS',
        'C__CATS__PDU',
        'C__CATS__PDU_BRANCH',
        'C__CATS__PDU_OVERVIEW',
        'C__CATS__BASIC_AUTH',
        'C__CATS__LICENCE_OVERVIEW',
        'C__CATS__PERSON_NAGIOS',
        'C__CATS__PERSON_GROUP_NAGIOS',
        'C__CATS__DATABASE_ACCESS',
        'C__CATS__LAYER2_NET_ASSIGNED_LOGICAL_PORTS',
        'C__CATS__LAYER2_NET_ASSIGNED_PORTS',
        'C__CATG__ASSIGNED_SIM_CARDS',
        'C__CATG__VRRP_MEMBER',
    ];

    public const ATTRIBUTES = [
        'C__CATG__CONTACT.contact',
        'C__CATG__GLOBAL.changed_by',
        'C__CATG__GLOBAL.created_by',
        'C__CATG__SLA.days',
        'C__CATG__CONNECTOR.assigned_connector',
        'C__CATG__NETWORK_PORT.assigned_connector',
        'C__CATG__NETWORK_LOG_PORT.assigned_connector',
        'C__CATG__POWER_CONSUMER.assigned_connector',
        'C__CATG__POWER_SUPPLIER.assigned_connector',
        'C__CATG__UNIVERSAL_INTERFACE.assigned_connector',
        'C__CATG__APPLICATION.assigned_databases',
        'C__CATG__OPERATING_SYSTEM.assigned_databases',
        'C__CATG__ASSIGNED_SIM_CARDS.isys_catg_cards_list__id',
        'C__CATG__CONTROLLER_FC_PORT.target',
        'C__CATG__CONTROLLER_FC_PORT.assigned_connector',
        'C__CATG__IP.dns_server',
        'C__CATG__LDEV_CLIENT.assigned_ldevserver',
        'C__CATG__LDEV_SERVER.ldev_clients',
        'C__CATG__VRRP_MEMBER.member',
        'C__CATS__APPLICATION_ASSIGNED_OBJ.assigned_databases',
        'C__CATS__APPLICATION_SERVICE_ASSIGNED_OBJ.assigned_databases',
        'C__CATS__APPLICATION_DBMS_ASSIGNED_OBJ.assigned_databases',
        'C__CATS__DATABASE_INSTALLATION.assigned_databases',
        'C__CATS__DATABASE_INSTANCE.instance',
        'C__CATS__LAYER2_NET_ASSIGNED_LOGICAL_PORTS.isys_catg_log_port_list__id',
        'C__CATS__LAYER2_NET_ASSIGNED_PORTS.isys_catg_port_list__id',
        'C__CATS__NET.dns_server',
    ];

    /**
     * @param array $constants
     *
     * @return array
     */
    public static function getBlockedCategoriesAsIds(array $constants)
    {
        return filter_defined_constants($constants);
    }
}
