<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto\Criteria;

use idoit\Module\SyneticsFlows\Dto\Criteria;
use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;

abstract class AggregateCriteria extends Criteria
{
    abstract public function getOperator(): string;

    /**
     * @param Criteria[] $items
     */
    public function __construct(
        #[ArrayFormat(Criteria::class)]
        protected array $items = []
    )
    {
    }

    public function getItems(): array
    {
        return $this->items;
    }
}