<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto\Criteria;

use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class RangeCriteria extends FieldCriteria
{
    public function __construct(
        ?string $field = null,
        #[Required]
        protected $start = null,
        #[Required]
        protected $end = null,
    )
    {
        parent::__construct($field);
    }

    /**
     * @return mixed
     */
    public function getStart(): mixed
    {
        return $this->start;
    }

    /**
     * @return mixed
     */
    public function getEnd(): mixed
    {
        return $this->end;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];

        if ($this->end < $this->start) {
            $results[] = new ValidationMessage([...$path, 'start'], 'LC__MODULE__SYNETICS_FLOWS__BEFORE_TO');
            $results[] = new ValidationMessage([...$path, 'end'], 'LC__MODULE__SYNETICS_FLOWS__AFTER_FROM');
        }

        return $results;
    }

    public function prepareReportManagerCondition(): array
    {
        $greater = (new GreaterOrEqualThanCriteria($this->field, $this->getStart()))->prepareReportManagerCondition();
        $less = (new LessOrEqualThanCriteria($this->field, $this->getEnd()))->prepareReportManagerCondition();

        return [
            $greater,
            'AND',
            $less,
        ];
    }
}
