<?php

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class CiObject implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        private string $title,
        private string $type,
        private string $typeId,
        private string $status,
        private ?string $sysId = null,
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getTypeId(): string
    {
        return $this->typeId;
    }

    public function getSysId(): ?string
    {
        return $this->sysId;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function __get($prop)
    {
        return $this->$prop;
    }

    public function __isset($prop): bool
    {
        return isset($this->$prop);
    }
}
