<?php

namespace idoit\Module\SyneticsFlows\Model\Dto;

class ObjectAttributeData extends AttributeData
{
    public string $type = 'object';

    public function __construct(
        string $id,
        string $title,
        protected string $objectType,
        protected string $status
    )
    {
        parent::__construct($id, $title);
    }

    /**
     * @return string
     */
    public function getObjectType(): string
    {
        return $this->objectType;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }
}
