<?php

/**
 * Class isys_jdisc_dao_category_sound
 */
class isys_jdisc_dao_category_sound extends isys_jdisc_dao_category implements isys_jdisc_dao_category_interface
{
    /**
     * @var string
     */
    protected $category = 'C__CATG__SOUND';

    /**
     * @var string
     */
    protected $title = 'LC__CMDB__CATG__SOUND';

    /**
     * @return string
     */
    protected function getQuery(): string
    {
        return "SELECT * FROM device as d
            INNER JOIN sounddevice s on d.id = s.deviceid %s";
    }

    /**
     * @param int $deviceId
     *
     * @return string
     */
    private function getCondition(int $deviceId): string
    {
        return 'WHERE d.id = ' . $this->convert_sql_int($deviceId);
    }

    /**
     * @param array $data
     *
     * @return array
     */
    protected function prepareData(array $data): array
    {
        return [
            'data_id'    => null,
            'properties' => [
                'manufacturer'        => [
                    'tag'   => 'manufacturer',
                    'value' => $data['manufacturer'],
                    'title' => 'LC__CMDB__CATG__MANUFACTURE',
                ],
                'title' => [
                    'tag'        => 'title',
                    'value'      => $data['model'],
                    'title'      => 'LC__CMDB__CATG__TITLE',
                ],
            ]
        ];
    }

    /**
     * @param int      $deviceId
     * @param          $asRaw
     * @param array    $deviceToObjectId
     * @param array    $idoitObjects
     * @param int|null $currentObjectId
     *
     * @return array
     */
    public function getDataForImport(int $deviceId, $asRaw = false, array $deviceToObjectId = [], array $idoitObjects = [], ?int $currentObjectId = null): array
    {
        $return = [];
        $result = $this->fetch(sprintf($this->getQuery(), $this->getCondition($deviceId)));
        $this->m_log->debug('> Found ' . $this->m_pdo->num_rows($result) . ' rows');

        while ($data = $this->m_pdo->fetch_row_assoc($result)) {
            if ($asRaw === true) {
                $return[] = $data;
            } else {
                $return[] = $this->prepareData($data);
            }
        }

        if ($asRaw === true || count($return) == 0) {
            return $return;
        } else {
            return [
                C__DATA__TITLE      => $this->language->get($this->title),
                'const'             => $this->category,
                'category_type'     => C__CMDB__CATEGORY__TYPE_GLOBAL,
                'category_entities' => $return
            ];
        }
    }
}
