<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type CustomAttributeTableFieldDescriptionInput
 * The CustomAttributeTable field description type * @property string $canonicalType Gets the canonical field type (FieldDescription, IdFieldDescription or KeyDescription)
 * @property null|string $canonicalValueType = null Gets the canonical field value type (e.g. Integer, Boolean, PercentValue, ...)
 * @property null|string $columnHeader = null Gets the label or column header within tables
 * @property null|string $fieldId = null Gets the internal field id
 * @property null|FieldNatureEnum $nature = null The nature for a field
 * @property null|string $type = null Gets the field type (FieldDescription, IdFieldDescription or KeyDescription)
 * @property null|string $valueType = null Gets the field value type (e.g. Integer, Boolean, PercentValue, ...)
 * @property null|FieldWidthEnumEnum $webFieldWidth = null Gets the field default width as enumeration (which is later mapped to a style in the WEB UI)
 * @property null|bool $isEncrypted = null Returns whether a field value is encrypted within the database or not.
 * @property null|bool $isEnumeration = null Checks whether a field is an enumeration value or not.
 * @property null|bool $isIdField = null Checks whether a field is an id field or not.
 * @property null|bool $isKeyField = null Checks whether a field is a key field or not.
 * @property null|bool $isMultilineField = null A flag whether this field can contain line breaks
 * @property null|bool $isNumeric = null Checks whether a field is a numeric field.
 */
final class CustomAttributeTableFieldDescriptionInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'nature') {
            return new FieldNatureEnum($value);
        }

        if ($name === 'webFieldWidth') {
            return new FieldWidthEnumEnum($value);
        }

        return $value;
    }
}