<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type CyberarkServerDataInput
 * This object contains information about the cyberark secret server. * @property null|string $appId = null The application id
 * @property null|CyberarkAuthenticationTypeEnum $authType = null The authentication type
 * @property null|string $ccpServerAddress = null The CCP server address (IP address or hostname). When null, it uses the same as the PVWA server config
 * @property null|int $ccpServerPort = null The CCP server port that the CCP server is listening on. (Uses the PVWA settings when null)
 * @property null|iterable|int[] $certificateBytes = null The client certificate bytes
 * @property null|string $clientCertificatePassword = null The Client Certificate password, if any
 * @property null|string $id = null The internal id this entity. Note that the id might change when the entity gets deleted and recreated.
 * @property null|string $name = null The server's descriptive name as provided by the user.
 * @property null|string $objectName = null The object name
 * @property null|string $password = null The password used to authenticate against the Cyberark server..
 * @property null|string $pvwaServerAddress = null The PVWA server address (IP address or hostname).
 * @property null|int $pvwaServerPort = null The port that the PVWA server is listening on.
 * @property null|string $safeName = null The safe name
 * @property null|PasswordManagementStatusInputInputType $status = null The server status
 * @property null|bool $useProxy = null A flag whether the API should use a proxy or not
 * @property null|string $username = null The username used to authenticate against the Cyberark server..
 * @property null|string $label = null The server label
 */
final class CyberarkServerDataInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'authType') {
            return new CyberarkAuthenticationTypeEnum($value);
        }

        if ($name === 'status') {
            return new PasswordManagementStatusInputInputType($value);
        }

        return $value;
    }
}