<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type DeviceRelationInput
 * A relation between two devices. The kind of relation is defined by the relation type. * @property null|string $displayName = null A display name for the relation (if any)
 * @property null|ConnectorStateEnum $state = null The state for a relation between two devices. This state is used
for instance for virtualation relations between the physical host and the VM
in order to indicate the virtual machine state
 * @property null|ConnectionDirectionEnum $direction = null The direction of the relation. Forward means source initiated, Backward means destination initiated.
 * @property null|string $internalId = null The connector internal id. The internal id depends on the relation type.
For VMware virtual machine relations, the type can be the VM UUID (unique id).
 * @property null|ConnectorTypeEnum $relationType = null The relation type for relations between two devices
 * @property null|DeviceInputInputType $sourceDevice = null The source device for the relation
 * @property null|DeviceInputInputType $targetDevice = null The target device for the relation
 */
final class DeviceRelationInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'state') {
            return new ConnectorStateEnum($value);
        }

        if ($name === 'direction') {
            return new ConnectionDirectionEnum($value);
        }

        if ($name === 'relationType') {
            return new ConnectorTypeEnum($value);
        }

        if ($name === 'sourceDevice') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'targetDevice') {
            return new DeviceInputInputType($value);
        }

        return $value;
    }
}