<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Resolver\AutoGenerationInterface;

/**
 * This code is @generated by axtiva/flexible-graphql-php
 * if you want to extend it or change, then remove interface AutoGenerationInterface
 * and it will be managed by you, not axtiva/flexible-graphql-php code generator
 * PHP representation of graphql type DiscoverySettings
 * Discovery Settings */
final class DiscoverySettingsType implements AutoGenerationInterface
{
    /**
     * flag to add virtualization physical server
     */
    public ?bool $addManagedPhysicalServers = null;
    /**
     * flag to add virtualization machines
     */
    public ?bool $addVirtualMachines = null;
    /**
     * flag to add virtualization management server
     */
    public ?bool $addVirtualizationManagementServer = null;
    /**
     * flag to delete users from logged on user history after specific time
     */
    public ?bool $ageOutLastLoggedOnUsersEnabled = null;
    /**
     * Aging out deletion logs in minutes
     */
    public $agingOutDeviceDeletionLogsInMinutes = null;
    /**
     * flag to age out device events
     */
    public ?bool $agingOutDeviceEventsEnabled = null;
    /**
     * Last Days to Collect Device Events
     */
    public ?int $agingOutDeviceEventsInDays = null;
    /**
     * Aging out devices flag
     */
    public ?bool $agingOutDevicesEnabled = null;
    /**
     * Aging out discovery events flag
     */
    public ?bool $agingOutDiscoveryEventsEnabled = null;
    /**
     * Aging out discovery events in minutes
     */
    public $agingOutDiscoveryEventsInMinutes = null;
    /**
     * Aging out devices in minutes
     */
    public $agingOutInMinutes = null;
    /**
     * flag to discover devices found in ARP caches of routers and switches
     */
    public ?bool $arpCacheReadingEnabled = null;
    /**
     * flag to enable remote jumphost
     */
    public ?bool $arpProxyEnabled = null;
    /**
     * Max count of server/client jumphost connection attempts per IP subnet
     */
    public ?int $arpProxyMaxSubnetCandidates = null;
    /**
     * flag to enable SNMP ARP table reading on routers and routing switches
     */
    public ?bool $arpSNMPRouterEnabled = null;
    /**
     * flag to create new devices for user connections from remote devices
     */
    public ?bool $createNewDevicesForRemoteConnectionClients = null;
    /**
     * Ibm DB2 database connect timeout in milliseconds
     */
    public $db2JdbcConnectTimeout = null;
    /**
     * flag to delete orphaned software that no longer belongs to any devices
     */
    public ?bool $deleteOrphanedSoftwareElements = null;
    /**
     * flag to delete inactive dependencies between computers after specific time
     */
    public ?bool $dependencyMappingAgingOutEnabled = null;
    /**
     * Seconds after which inactive dependencies between computers are deleted
     */
    public ?int $dependencyMappingAgingSeconds = null;
    /**
     * Device Naming Method
     */
    public ?DeviceNamingMethodEnum $deviceNamingMethod = null;
    /**
     * Device Naming Strategy
     */
    public ?DeviceNamingStrategyEnum $deviceNamingStrategy = null;
    /**
     * flag to discover anonymous Wlans (without SSID)
     */
    public ?bool $discoverAnonymousWlans = null;
    /**
     * flag to discover antivirus software
     */
    public ?bool $discoverAntivirusSoftware = null;
    /**
     * flag to discover applications
     */
    public ?bool $discoverApplications = null;
    /**
     * flag to discover remote clients
     */
    public ?bool $discoverBladeEnclosureComponents = null;
    /**
     * flag to discover certificates
     */
    public ?bool $discoverCertificates = null;
    /**
     * flag to discover https certificates
     */
    public ?bool $discoverCertificatesWebSites = null;
    /**
     * flag to Discover Cisco Support Entitlements
     */
    public ?bool $discoverCiscoSupportEntitlements = null;
    /**
     * flag to discover client access licenses
     */
    public ?bool $discoverClientAccessLicenses = null;
    /**
     * flag to Discover Cloud Users
     */
    public ?bool $discoverCloudUsers = null;
    /**
     * flag to discover cluster
     */
    public ?bool $discoverClusterConfiguration = null;
    /**
     * flag to discover containers
     */
    public ?bool $discoverContainer = null;
    /**
     * flag to discover custom attributes
     */
    public ?bool $discoverCustomAttributes = null;
    /**
     * flag to discover schemas within databases
     */
    public ?bool $discoverDatabaseSchemas = null;
    /**
     * flag to discover tables within schemas of databases
     */
    public ?bool $discoverDatabaseTables = null;
    /**
     * flag to discover database details
     */
    public ?bool $discoverDatabases = null;
    /**
     * flag to Discover Dell Support Entitlements
     */
    public ?bool $discoverDellSupportEntitlements = null;
    /**
     * flag to discover Direct X version
     */
    public ?bool $discoverDirectXVersion = null;
    /**
     * flag to discover attached devices
     */
    public ?bool $discoverDirectlyAttachedDevices = null;
    /**
     * flag to discover disks
     */
    public ?bool $discoverDisks = null;
    /**
     * Flag to Discover Dns Domain Controllers
     */
    public ?bool $discoverDnsDomainControllers = null;
    /**
     * Flag to discover Dns Servers
     */
    public ?bool $discoverDnsServers = null;
    /**
     * flag to discover drivers
     */
    public ?bool $discoverDrivers = null;
    /**
     * flag to discover exchange server mailboxes
     */
    public ?bool $discoverExchangeServerMailboxes = null;
    /**
     * flag to discover exe files
     */
    public ?bool $discoverExeFiles = null;
    /**
     * flag to discover firewall configuration
     */
    public ?bool $discoverFirewallConfiguration = null;
    /**
     * flag to Discover Fujitsu Support Entitlements
     */
    public ?bool $discoverFujitsuSupportEntitlements = null;
    /**
     * flag to discover ISCSI initiators and targets
     */
    public ?bool $discoverICSIConfiguration = null;
    /**
     * flag to Discover Lenovo Support Entitlements
     */
    public ?bool $discoverLenovoSupportEntitlements = null;
    /**
     * flag to Discover Lexmark Support Entitlements
     */
    public ?bool $discoverLexmarkSupportEntitlements = null;
    /**
     * flag to discover licenses
     */
    public ?bool $discoverLicenses = null;
    /**
     * flag to discover card readers
     */
    public ?bool $discoverLocalCardReaders = null;
    /**
     * flag to discover local printers
     */
    public ?bool $discoverLocalPrinters = null;
    /**
     * flag to discover local scanners
     */
    public ?bool $discoverLocalScanners = null;
    /**
     * flag to discover managed devices
     */
    public ?bool $discoverManagedDevices = null;
    /**
     * flag to discover mapped printers
     */
    public ?bool $discoverMappedPrinters = null;
    /**
     * flag to discover memory modules
     */
    public ?bool $discoverMemoryModules = null;
    /**
     * flag to discover monitors
     */
    public ?bool $discoverMonitors = null;
    /**
     * flag to discover motion events
     */
    public ?bool $discoverMotionEvents = null;
    /**
     * flag to discover offline virtual instances
     */
    public ?bool $discoverOfflineVirtualInstances = null;
    /**
     * flag to run Oracle LMS scripts
     */
    public ?bool $discoverOracleLMSConfiguration = null;
    /**
     * flag to discover patches
     */
    public ?bool $discoverPatches = null;
    /**
     * flag to discover pending installations
     */
    public ?bool $discoverPendingInstallations = null;
    /**
     * flag to discover process loaded modules
     */
    public ?bool $discoverProcessLoadedModules = null;
    /**
     * flag to discover processes
     */
    public ?bool $discoverProcesses = null;
    /**
     * flag to discover processors
     */
    public ?bool $discoverProcessors = null;
    /**
     * flag to discover reachable WLANs
     */
    public ?bool $discoverReachableWlans = null;
    /**
     * flag to discover reboot, shutdown and bluescreen events
     */
    public ?bool $discoverRebootEvents = null;
    /**
     * flag to discover remote clients
     */
    public ?bool $discoverRemoteConnectionClients = null;
    /**
     * flag to discover scheduled tasks
     */
    public ?bool $discoverScheduledTasks = null;
    /**
     * flag to discover services
     */
    public ?bool $discoverServices = null;
    /**
     * flag to discover shares
     */
    public ?bool $discoverShares = null;
    /**
     * flag to discover sim cards
     */
    public ?bool $discoverSimCards = null;
    /**
     * flag to discover sound devices
     */
    public ?bool $discoverSoundDevices = null;
    /**
     * flag to scan SSL configuration
     */
    public ?bool $discoverSslConfig = null;
    /**
     * Collecting support entitlements time interval
     */
    public ?int $discoverSupportEntitlementEveryNDays = null;
    /**
     * flag to Discover Support Entitlements
     */
    public ?bool $discoverSupportEntitlements = null;
    /**
     * flag to discover Swidtag Files
     */
    public ?bool $discoverSwidtagFiles = null;
    /**
     * flag to Discover Tochiba Support Entitlements
     */
    public ?bool $discoverToshibaSupportEntitlements = null;
    /**
     * flag to discover Tpm modules
     */
    public ?bool $discoverTpmModule = null;
    /**
     * flag to Discover User Groups
     */
    public ?bool $discoverUserGroups = null;
    /**
     * flag to Discover Users
     */
    public ?bool $discoverUsers = null;
    /**
     * flag to discover snapshots
     */
    public ?bool $discoverVMSnasphots = null;
    /**
     * flag to discover VMware annotations
     */
    public ?bool $discoverVMwareCustomAttributes = null;
    /**
     * flag to discover video controllers
     */
    public ?bool $discoverVideoControllers = null;
    /**
     * flag to discover virtual instances
     */
    public ?bool $discoverVirtualInstances = null;
    /**
     * flag to discover windows features
     */
    public ?bool $discoverWindowsFeatures = null;
    /**
     * flag to discover Wlan Access Points
     */
    public ?bool $discoverWlanAccessPoints = null;
    /**
     * flag to discover Wlans
     */
    public ?bool $discoverWlans = null;
    /**
     * flag to Discover Xerox Support Entitlements
     */
    public ?bool $discoverXeroxSupportEntitlements = null;
    /**
     * flag to Discover Zebra Support Entitlements
     */
    public ?bool $discoverZebraSupportEntitlements = null;
    /**
     * Https connection for EoL data timeout in milliseconds
     */
    public ?int $endOfLifeHttpsConnectTimeout = null;
    /**
     * Https read of EoL data timeout in milliseconds
     */
    public ?int $endOfLifeHttpsReadTimeout = null;
    /**
     * flag to discover support End of Life information
     */
    public ?bool $endOfLifeSupportEnabled = null;
    /**
     * Days interval to update end of life data
     */
    public ?int $endOfLifeUpdateIntervalInDays = null;
    /**
     * Powershell execution timeout in milliseconds (to discover exchange server mailboxes)
     */
    public $exchangePowershellScriptExecuteTimeout = null;
    /**
     * flag to detect remote connections via RDP, SSH or telnet
     */
    public ?bool $findRemoteClientConnections = null;
    /**
     * Informix database connect timeout in milliseconds
     */
    public $informixJdbcConnectTimeout = null;
    /**
     * flag to check Java licensing
     */
    public ?bool $javaLicensingCheck = null;
    /**
     * flag to keep disconnected monitors
     */
    public ?bool $keepDiscoverMonitors = null;
    /**
     * Kill Inactive Device After Seconds
     */
    public ?int $killInactiveDevicesAfterSeconds = null;
    /**
     * Hours after which logged on users history is deleted
     */
    public ?int $lastLoggedOnUsersAgeOutHours = null;
    /**
     * SAP MaxDB database connect timeout in milliseconds
     */
    public $maxDbJdbcConnectTimeout = null;
    /**
     * Max Ping Threads
     */
    public ?int $maxPingThreads = null;
    /**
     * Max Threads
     */
    public ?int $maxThreads = null;
    /**
     * MongoDB database connect timeout in milliseconds
     */
    public $mongoDbJdbcConnectTimeout = null;
    /**
     * Last days to collect motion events
     */
    public ?int $motionEventsHistorySinceDays = null;
    /**
     * MS SQLServer database connect timeout in milliseconds
     */
    public $mssqlServerDbJdbcConnectTimeout = null;
    /**
     * MySQL/MariaDB database connect timeout in milliseconds
     */
    public $mySqlJdbcConnectTimeout = null;
    /**
     * Network Creation Policy
     */
    public ?NetworkCreationPolicyEnum $networkCreationPolicy = null;
    /**
     * Oracle database connect timeout in milliseconds
     */
    public $oracleDbJdbcConnectTimeout = null;
    /**
     * The location of oracle LMS zip file on discovery server
     */
    public ?string $oracleLmsZipFile = null;
    /**
     * flag to ignore directly attached devices when connected via VPN
     */
    public ?bool $policyDoNotDiscoverAttachedDevicesWhenConnectedToVpn = null;
    /**
     * flag to ignore mDNS and UPnP enabled devices when connected via VPN
     */
    public ?bool $policyDoNotDiscoverMdnsUpnpDevicesWhenConnectedToVpn = null;
    /**
     * flag to ignore WLANs when connected via VPN
     */
    public ?bool $policyDoNotDiscoverWlansWhenConnectedToVpn = null;
    /**
     * Postgres database connect timeout in milliseconds
     */
    public $postgresDbJdbcConnectTimeout = null;
    /**
     * flag to purge older motion events
     */
    public ?bool $purgeOldMotionEvents = null;
    /**
     * flag to discover ssh security algorithms
     */
    public ?bool $scanSshAlgorithmsEnabled = null;
    /**
     * Sybase database connect timeout in milliseconds
     */
    public $sybaseJdbcConnectTimeout = null;
    /**
     * Track device deletion flag
     */
    public ?bool $trackDeviceDeletion = null;
    /**
     * Use hostname only for name flag
     */
    public ?bool $useHostnameOnlyForName = null;
    /**
     * Method to identify Vlans
     */
    public ?VLanIdentificationMethodEnum $vlanIdentification = null;
    /**
     * The list of WLAN white list patterns
     * @var null|iterable
     */
    public ?iterable $wlanWhitelistPatterns = null;
}