<?php

namespace idoit\Module\SyneticsJdisc\Helper;

class JDiscConsoleProgressBar implements JDiscProgressBarInterface
{
    private $progressBar;

    public function __construct($progressBar)
    {
        $this->progressBar = $progressBar;
    }

    public function setMessage(string $message, string $name = 'message'): void
    {
        $this->progressBar->setMessage($message, $name);
    }

    public function advance(int $step = 1): void
    {
        $this->progressBar->advance($step);
    }

    public function setMaxSteps(int $max): void
    {
        $this->progressBar->setMaxSteps($max);
    }

    public function finish(): void
    {
        $this->progressBar->finish();
    }
}
