<?php

namespace idoit\Module\SyneticsJdisc\Helper;

interface JDiscProgressBarInterface
{
    /**
     * Associates a text with a named placeholder.
     *
     * @param string $message The text to associate with the placeholder
     * @param string $name    The name of the placeholder
     * @return void
     */
    public function setMessage(string $message, string $name = 'message'): void;

    /**
     * Advances the progress output X steps.
     *
     * @param int $step Number of steps to advance
     * @return void
     */
    public function advance(int $step = 1): void;

    public function setMaxSteps(int $max): void;

    /**
     * Finishes the progress output.
     */
    public function finish(): void;
}
