<?php

namespace idoit\Module\SyneticsJdisc\Model\Dto;

use JsonSerializable;
use Idoit\Dto\Serialization\SerializableTrait;

class Log implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id = '',
        private ?string $start_date = '',
        private ?string $end_date = '',
        private ?string $status = '',
        private ?array $server_info = [],
        private ?array $profile_info = [],
        private ?string $file_name = '',
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getStartDate(): ?string
    {
        return $this->start_date;
    }

    public function getEndDate(): ?string
    {
        return $this->end_date;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function getServerInfo(): ?string
    {
        return $this->server_info;
    }

    public function getProfileInfo(): ?string
    {
        return $this->profile_info;
    }

    public function getFileName(): ?string
    {
        return $this->file_name;
    }
}
