<?php
namespace idoit\Module\SyneticsJdisc\Graphql\Query\Job;

use GraphQL\Query;
use GraphQL\Results;
use idoit\Module\SyneticsJdisc\Graphql\AbstractGraphql;
use idoit\Module\SyneticsJdisc\Graphql\ResponseInterface;
use idoit\Module\SyneticsJdisc\Graphql\Type\AbstractType;
use idoit\Module\SyneticsJdisc\Graphql\Type\StringType;

class GetJobByName extends AbstractGraphql implements ResponseInterface
{
    /**
     * @var StringType
     */
    private StringType $name;

    /**
     * @param StringType $name
     */
    public function setName(StringType $name): void
    {
        $this->name = $name;
    }

    /**
     * @return array|AbstractType[]
     */
    public function getParameters(): array
    {
        return [
            $this->name
        ];
    }

    /**
     * @return string[]
     */
    public function getSelections(): array
    {
        return [
            'id',
            'name',
            'description'
        ];
    }

    /**
     * @return Query
     */
    public function getQuery(): Query
    {
        return (new Query('discovery'))
            ->setVariables($this->buildVariables())
            ->setSelectionSet([
                (new Query('discoveryJobs'))
                    ->setSelectionSet([
                        (new Query('findByName'))
                            ->setArguments($this->buildArguments())
                            ->setSelectionSet($this->getSelections())
                    ])
            ]);
    }

    /**
     * @param Results $results
     *
     * @return array
     */
    public static function getDataFromResults(Results $results): array
    {
        $data = $results->getData();
        return $data['discovery']['discoveryJobs']['findByName'];
    }
}
