<?php

declare (strict_types=1);
namespace idoit\Module\SyneticsJdisc\Graphql\Schema\Model;

use Axtiva\FlexibleGraphql\Type\InputType;

/**
 * This code is @generated by axtiva/flexible-graphql-php do not edit it
 * PHP representation of graphql type IscsiPortInput
 * An ISCSI port (either initiator or target depending on the type field) * @property null|string $alias = null The alias for this port
 * @property null|DeviceInputInputType $device = null The owning device
 * @property null|iterable|IscsiPortConnectionInputInputType[] $initiatorConnections = null The connections where the port is the initiator
 * @property null|string $iqn = null The IQN (iSCSI qualified name)
 * @property null|iterable|IscsiPortConnectionInputInputType[] $targetConnections = null The connections where the port is the target
 * @property null|ISCSIPortTypeEnum $type = null The iscsi port type
 * @property null|iterable|IscsiPortConnectionInputInputType[] $connections = null Gets all connections
 */
final class IscsiPortInputInputType extends InputType
{
    protected function decorate($name, $value)
    {
        if ($value === null) {
            return null;
        }

        if ($name === 'device') {
            return new DeviceInputInputType($value);
        }

        if ($name === 'initiatorConnections') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IscsiPortConnectionInputInputType($v)); })($value);
        }

        if ($name === 'targetConnections') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IscsiPortConnectionInputInputType($v)); })($value);
        }

        if ($name === 'type') {
            return new ISCSIPortTypeEnum($value);
        }

        if ($name === 'connections') {
            return (function($value) {foreach($value as $v) yield ($v === null ? null : new IscsiPortConnectionInputInputType($v)); })($value);
        }

        return $value;
    }
}