<?php

namespace idoit\Module\SyneticsJdisc\Model;

use idoit\Model\Dao\Base;
use isys_application;
use isys_jdisc_dao;
use isys_module_request;
use isys_module_synetics_jdisc;

abstract class AbstractDao extends Base
{
    private isys_jdisc_dao $jdiscDao;

    private isys_module_synetics_jdisc $jdiscModule;

    /**
     * @throws \Exception
     */
    public function __construct()
    {
        $db = isys_application::instance()->container->get('database');
        parent::__construct($db);
        $this->jdiscDao = new isys_jdisc_dao($db, null);
        $this->jdiscModule = isys_module_synetics_jdisc::factory()->init(isys_module_request::get_instance());
    }

    public function getProperties(): array
    {
        return [];
    }

    /**
     * @return isys_jdisc_dao
     */
    public function getJdiscDao(): isys_jdisc_dao
    {
        return $this->jdiscDao;
    }

    public function getJdiscModule(): isys_module_synetics_jdisc
    {
        return $this->jdiscModule;
    }

    /**
     * @return string[]
     */
    public function getHeaders(string $type): array
    {
        $properties = $this->jdiscDao->get_properties($type);

        foreach ($properties as $property) {
            $header[$property[C__PROPERTY__DATA][C__PROPERTY__DATA__FIELD]] = $property[C__PROPERTY__INFO][C__PROPERTY__INFO__TITLE];
        }
        return $header;
    }

    /**
     * @param array $data
     *
     * @return array
     */
    public function validateData(array $data)
    {
        $properties = $this->getProperties();

        return $this->getJdiscModule()->validateData($properties, $data);
    }
}
