<?php

namespace idoit\Module\SyneticsJdisc\Model\Dto;

use JsonSerializable;
use Idoit\Dto\Serialization\SerializableTrait;
use Idoit\Dto\Validation\Required;

class DiscoveryServer implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        #[Required]
        private ?string $name = '',
        private ?string $description = '',
        private ?string $host = '',
        private ?string $port = '',
        private ?string $database = '',
        private ?string $username = '',
        private ?string $password = '',
        private ?string $version_check = '',
        private ?string $default_server = '',
        private ?string $discovery_username = '',
        private ?string $discovery_password = '',
        private ?string $discovery_port = '',
        private ?string $discovery_protocol = '',
        private ?string $discovery_timeout = '',
        private ?string $discovery_import_retries = ''
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getHost(): ?string
    {
        return $this->host;
    }

    public function getPort(): ?string
    {
        return $this->port;
    }

    public function getDatabase(): ?string
    {
        return $this->database;
    }

    public function getUsername(): ?string
    {
        return $this->username;
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }

    public function getVersionCheck(): ?string
    {
        return $this->version_check;
    }

    public function getDefaultServer(): ?string
    {
        return $this->default_server;
    }

    public function getDiscoveryUsername(): ?string
    {
        return $this->discovery_username;
    }

    public function getDiscoveryPassword(): ?string
    {
        return $this->discovery_password;
    }

    public function getDiscoveryPort(): ?string
    {
        return $this->discovery_port;
    }

    public function getDiscoveryProtocol(): ?string
    {
        return $this->discovery_protocol;
    }

    public function getDiscoveryTimeout(): ?string
    {
        return $this->discovery_timeout;
    }

    public function getDiscoveryImportRetries(): ?string
    {
        return $this->discovery_import_retries;
    }
}
