<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsJdisc\Model\Dto;

use JsonSerializable;
use Idoit\Dto\Serialization\ReadonlyFormat;
use Idoit\Dto\Serialization\SerializableTrait;
use Idoit\Dto\Validation\Required;

class SyncProfile implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id = '',
        #[Required]
        private ?string $name = '',
        private ?string $description = '',
        private ?array $categories = null,
        private ?string $import_all_software = '',
        private ?string $import_software_licences = '',
        private ?string $import_software_services = '',
        private ?string $import_all_networks = '',
        private ?string $import_all_clusters = '',
        private ?string $import_all_blade_connections = '',
        private ?array  $jdisc_server = null,
        private ?string $import_custom_attributes = '',
        private ?string $import_all_vlans = '',
        private ?string $import_type_interfaces = '',
        private ?array $cmdb_status = null,
        private ?string $use_default_templates = '',
        private ?array $software_filter = null,
        private ?string $software_obj_title = '',
        private ?string $update_objtype = '',
        private ?string $update_obj_title = '',
        private ?string $chassis_module_update_objtype = '',
        private ?string $use_simple_database_mod = '',
        private ?array $network_adresses = null,
        private ?string $import_type_dhcp_addresses = '',
        private ?string $import_cloud_subscriptions = '',
        private ?string $import_connection_endpoint = '',
        private ?string $import_create_cloud_users = '',
        private ?string $adopt_location = '',
        private ?string $last_scanned_device = '',
        private ?string $resolve_fqdn = '',
        private ?array $network_import_filter = null,
        private ?array  $mac_filter = null,
        private ?array $software_location = null,
        private ?array $network_location = null,
        private ?array $cmdb_status_create = null,
        private ?array $chassis_assigned_modules_objtype = null,
        private ?array $type_map = null,
        private ?array $column_settings = null,
        private ?array $conf_server = null,
        #[ReadonlyFormat]
        private ?string $lastSync = null
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getCategories(): ?array
    {
        return $this->categories;
    }

    public function getImportAllSoftware(): ?string
    {
        return $this->import_all_software;
    }

    public function getImportSoftwareLicences(): ?string
    {
        return $this->import_software_licences;
    }

    public function getImportSoftwareServices(): ?string
    {
        return $this->import_software_services;
    }

    public function getImportAllNetworks(): ?string
    {
        return $this->import_all_networks;
    }

    public function getImportAllClusters(): ?string
    {
        return $this->import_all_clusters;
    }

    public function getImportAllBladeConnections(): ?string
    {
        return $this->import_all_blade_connections;
    }

    public function getJdiscServer(): ?array
    {
        return $this->jdisc_server;
    }

    public function getImportCustomAttributes(): ?string
    {
        return $this->import_custom_attributes;
    }

    public function getImportAllVlans(): ?string
    {
        return $this->import_all_vlans;
    }

    public function getImportTypeInterfaces(): ?string
    {
        return $this->import_type_interfaces;
    }

    public function getCmdbStatus(): ?array
    {
        return $this->cmdb_status;
    }

    public function getUseDefaultTemplates(): ?string
    {
        return $this->use_default_templates;
    }

    public function getSoftwareFilter(): ?array
    {
        return $this->software_filter;
    }


    public function getSoftwareObjTitle(): ?string
    {
        return $this->software_obj_title;
    }

    public function getUpdateObjtype(): ?string
    {
        return $this->update_objtype;
    }

    public function getUpdateObjTitle(): ?string
    {
        return $this->update_obj_title;
    }

    public function getChassisModuleUpdateObjtype(): ?string
    {
        return $this->chassis_module_update_objtype;
    }

    public function getUseSimpleDatabaseMod(): ?string
    {
        return $this->use_simple_database_mod;
    }

    public function getNetworkAdresses(): ?array
    {
        return $this->network_adresses;
    }

    public function getImportTypeDhcpAddresses(): ?string
    {
        return $this->import_type_dhcp_addresses;
    }

    public function getImportCloudSubscriptions(): ?string
    {
        return $this->import_cloud_subscriptions;
    }

    public function getImportConnectionEndpoint(): ?string
    {
        return $this->import_connection_endpoint;
    }

    public function getImportCreateCloudUsers(): ?string
    {
        return $this->import_create_cloud_users;
    }

    public function getAdoptLocation(): ?string
    {
        return $this->adopt_location;
    }

    public function getLastScannedDevice(): ?string
    {
        return $this->last_scanned_device;
    }

    public function getResolveFqdn(): ?string
    {
        return $this->resolve_fqdn;
    }

    public function getNetworkImportFilter(): ?array
    {
        return $this->network_import_filter;
    }

    public function getMacFilter(): ?array
    {
        return $this->mac_filter;
    }

    public function getSoftwareLocation(): ?array
    {
        return $this->software_location;
    }

    public function getNetworkLocation(): ?array
    {
        return $this->network_location;
    }

    public function getCmdbStatusCreate(): ?array
    {
        return $this->cmdb_status_create;
    }

    public function getLastSync(): ?string
    {
        return $this->lastSync;
    }

    public function getChassisAssignedModulesObjtype(): ?array
    {
        return $this->chassis_assigned_modules_objtype;
    }

    public function getTypeMap(): ?array
    {
        return $this->type_map;
    }

    public function getColumnSettings(): ?array
    {
        return $this->column_settings;
    }

    public function getConfServer(): ?array
    {
        return $this->conf_server;
    }

    /**
     * @param array|null $type_map
     * @return SyncProfile
     */
    public function setTypeMap(?array $type_map): self
    {
        $this->type_map = $type_map;
        return $this;
    }

    public function setLastSync(?string $lastSync): self
    {
        $this->lastSync = $lastSync;
        return $this;
    }
}
