<?php

namespace idoit\Module\SyneticsJdisc;

use idoit\Component\FeatureManager\FeatureManager;
use idoit\Tree\Node;
use isys_application as Application;
use isys_auth;
use isys_component_tree;
use isys_module_synetics_jdisc as ModuleJdisc;

class Tree
{
    /**
     * @return Node
     */
    public function render()
    {
        global $g_dirs;

        $tree = isys_component_tree::factory('menu_tree');
        $wwwPath = Application::instance()->www_path;

        // Prepare the language manager.
        $language = Application::instance()->container->get('language');

        $auth = ModuleJdisc::getAuth();

        // Prepare the root node.
        $rootNode = new Node(
            $language->get('LC__MODULE__JDISC'),
            '',
            ModuleJdisc::getWwwPath() . 'assets/jdisc.png'
        );

        $dashboardNode = new Node(
            $language->get('LC__JDISC__TREE__DASHBOARD'),
            $wwwPath . 'jdisc/dashboard',
            ModuleJdisc::getWwwPath() . 'assets/dashboard.svg',
            '',
            '',
            '',
            $auth->is_allowed_to(isys_auth::VIEW, 'dashboard')
        );

        $deviceListNode = new Node(
            $language->get('LC__JDISC__TREE__DEVICE_LIST'),
            $wwwPath . 'jdisc/device-list',
            $g_dirs['images'] . 'axialis/documents-folders/document.svg',
            '',
            '',
            '',
            $auth->is_allowed_to(isys_auth::VIEW, 'device-list')
        );

        if (FeatureManager::isFeatureActive('jdisc-settings')) {
            $syncProfilesNode = new Node(
                $language->get('LC__JDISC__TREE__SYNC_PROFILES'),
                $wwwPath . 'jdisc/sync-profile',
                $g_dirs['images'] . 'axialis/documents-folders/document.svg',
                '',
                '',
                '',
                $auth->is_allowed_to(isys_auth::VIEW, 'sync-profiles')
            );

            $discoveryServerNode = new Node(
                $language->get('LC__JDISC__TREE__DISCOVERY_SERVER'),
                $wwwPath . 'jdisc/discovery-server',
                $g_dirs['images'] . 'axialis/database/server.svg',
                '',
                '',
                '',
                $auth->is_allowed_to(isys_auth::VIEW, 'discovery-server')
            );
        }

        $logsNode = new Node(
            $language->get('LC__JDISC__TREE__LOGS'),
            $wwwPath . 'jdisc/logs',
            $g_dirs['images'] . 'axialis/basic/book-open.svg',
            '',
            '',
            '',
            $auth->is_allowed_to(isys_auth::VIEW, 'logs')
        );

        return $rootNode
            ->add($dashboardNode)
            ->add($deviceListNode)
            ->add($syncProfilesNode)
            ->add($discoveryServerNode)
            ->add($logsNode);
    }
}
