<?php

namespace idoit\Module\SyneticsJdisc\View;

use idoit\Module\SyneticsJdisc\Tree;
use idoit\Response\IdoitResponse;
use isys_application;
use isys_component_template;
use isys_component_template_language_manager;
use Symfony\Component\HttpFoundation\Response;

abstract class AbstractView
{
    public isys_component_template $template;
    public isys_component_template_language_manager $language;

    private ?int $mode = null;

    public function __construct() {
        $this->template = isys_application::instance()->container->get('template');
        $this->language = isys_application::instance()->container->get('language');
    }
    /**
     * @param int $mode
     *
     * @return static
     */
    public function setMode(int $mode): static
    {
        $this->mode = $mode;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getMode(): ?int
    {
        return $this->mode;
    }

    /**
     * @return Response
     * @throws \Exception
     */
    public static function getResponse(): Response
    {
        return (new IdoitResponse(''))
            ->setNavigationTree((new Tree())->render(), false);
    }

    /**
     * @return static
     */
    abstract public static function factory(): static;

    /**
     * @return Response
     */
    abstract public function render(): Response;
}
