<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Argument;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;
use JsonSerializable;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;

#[Discriminator([
    'string' => StringArgument::class,
])]
abstract class IdoitCliArgument implements JsonSerializable
{
    use SerializableTrait;

    protected string $description;

    public function __construct(protected string $name, string $description, protected bool $required)
    {
        $this->description = strip_tags($description);
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function isRequired(): bool
    {
        return $this->required;
    }

    public function validate(mixed $value): array
    {
        $errors = [];
        if ($this->required && !$value) {
            $errors[] = new ValidationMessage([$this->name], Required::DEFAULT_MESSAGE);
        }

        return $errors;
    }

    public function apply(InputInterface $input, mixed $value): void
    {
        $input->setArgument($this->name, $value);
    }
}