<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\DataSource;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option\SelectOptionValue;
use idoit\Module\SyneticsFlows\Model\CategoryDao;
use idoit\Module\SyneticsFlows\Model\Dto\Category;

class CategoryDataSource implements DataSource
{
    public function __construct(private CategoryDao $dao)
    {
    }

    public function getValues(array $parameters): array
    {
        $values = array_map(fn (Category $category) => new SelectOptionValue($category->getId(), $category->getTitle()), $this->dao->getData());

        return $values;
    }
}