<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType\IdoitCommand\Option;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputOption;

class StringSelectOptionConverter implements OptionConverter
{
    /**
     * @var SelectOptionValue[][][]
     */
    private array $options;

    public function __construct()
    {
        $objectStatus = [
            new SelectOptionValue('1', 'unfinished'),
            new SelectOptionValue('3', 'archived'),
            new SelectOptionValue('4', 'deleted'),
        ];

        $this->options = [
            'system-objectcleanup' => [
                'objectStatus' => $objectStatus,
            ],
            'system-categorycleanup' => [
                'categoryStatus' => $objectStatus,
            ],
            'report-export' => [
                'exportFileType' => [
                    new SelectOptionValue('csv', 'CSV'),
                    new SelectOptionValue('txt', 'TXT'),
                    new SelectOptionValue('pdf', 'PDF'),
                    new SelectOptionValue('xml', 'XML'),
                ]
            ],
            'import-csv' => [
                'multiValueMode' => [
                    new SelectOptionValue('row', 'Row'),
                    new SelectOptionValue('column', 'Column'),
                    new SelectOptionValue('comma', 'Comma'),
                ],
                'multi-value-update-mode' => [
                    new SelectOptionValue('create-if-empty', 'Create if empty'),
                    new SelectOptionValue('add', 'Add'),
                    new SelectOptionValue('replace', 'Replace'),
                ],
            ]
        ];
    }

    public function convert(Command $command, InputOption $option): ?IdoitCliOption
    {
        $values = $this->options[$command->getName()][$option->getName()] ?? null;

        if (!is_array($values)) {
            return null;
        }
        $default = $option->getDefault();

        return new StringSelectOption($option->getName(), $option->getDescription(), $option->isValueRequired(), $values, is_string($default) ? $default : null);
    }

    public function supports(Command $command, InputOption $option): bool
    {
        if (!$option->acceptValue() || $option->isArray()) {
            return false;
        }
        return isset($this->options[$command->getName()][$option->getName()]);
    }
}