<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\AuthType\AuthType;
use idoit\Module\SyneticsFlows\Validation\OneOf;
use idoit\Module\SyneticsFlows\Validation\Required;

class PerformApiCall extends ExecutionInfo
{
    public function __construct(
        #[Required]
        private ?string $url = null,
        #[OneOf(['GET', 'POST', 'PUT', 'PATCH', 'DELETE'])]
        private ?string $method = null,
        private ?AuthType $authType = null,
        private array $headers = [],
        private array $queryParams = [],
        private ?string $body = null,
    )
    {
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function getMethod(): ?string
    {
        return $this->method;
    }

    public function getAuthType(): ?AuthType
    {
        return $this->authType;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public function getQueryParams(): array
    {
        return $this->queryParams;
    }

    public function getBody(): ?string
    {
        return $this->body;
    }

    public function __toString(): string
    {
        return "Call {$this->method} {$this->url}";
    }
}