<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo;

use idoit\Module\SyneticsFlows\Validation\Required;

class SendEmailInfo extends ExecutionInfo
{
    public function __construct(
        #[Required]
        private ?array $recipient = null,
        #[Required]
        private ?string $subject = null,
        #[Required]
        private ?string $body = null,
    )
    {
    }

    public function getRecipient(): ?array
    {
        return $this->recipient;
    }

    public function getSubject(): ?string
    {
        return $this->subject;
    }

    public function getBody(): ?string
    {
        return $this->body;
    }

    public function __toString(): string
    {
        $recipient = !empty($this->getRecipient()) ? ' to ' . implode(', ', $this->getRecipient()) : '';
        return 'Send e-mail ' . $this->subject . $recipient;
    }
}
