<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CategoryChange;
use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Validation\Required;

class UpdateDataInfo extends ExecutionInfo
{
    public function __construct(
        #[Required]
        private ?array $objectIds = [],
        #[ArrayFormat(CategoryChange::class)]
        private array $changes = [],
    )
    {
    }

    public function getObjectIds(): ?array
    {
        return $this->objectIds;
    }

    /**
     * @return CategoryChange[]
     */
    public function getChanges(): array
    {
        return $this->changes;
    }

    public function __toString(): string
    {
        $count = count($this->objectIds);
        if ($count === 1) {
            return 'Update object';
        }
        return "Update $count objects";
    }
}
