<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

class ErrorApiCallResult extends ErrorExecutionResult implements ErrorExecutionInterface
{
    public function __construct(
        private int $statusCode,
        private string $body,
        private array $headers,
    )
    {
        parent::__construct();
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }
}
