<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

class SuccessApiCallResult extends ExecutionResult
{
    public function __construct(
        private int $statusCode,
        private string $body,
        private array $headers,
    )
    {
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    public function __toString(): string
    {
        return "Success: {$this->statusCode}";
    }
}