<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Condition;

use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class TimeCondition extends Condition
{
    public function __construct(
        #[Required]
        #[ArrayFormat(TimeConditionRange::class)]
        private array $ranges = [],
    )
    {
    }

    public function getRanges(): array
    {
        return $this->ranges;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];
        if (!count($this->ranges)) {
            $results[] = new ValidationMessage([...$path, 'ranges'], 'LC__MODULE__SYNETICS_FLOWS__AT_LEAST_ONE_TIME');
        }

        return $results;
    }
}
