<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

use DateTime;

class CategoryContext extends InvocationContext
{
    public function __construct(private string $category, private string $categoryType, ?string $userId = null, ?DateTime $time = null)
    {
        $context = InvocationContext::fromEnvironment();
        parent::__construct($userId ?? $context->getUserId(), $time ?? $context->getTime());
    }

    public function getCategory(): string
    {
        return $this->category;
    }

    public function getCategoryType(): string
    {
        return $this->categoryType;
    }
}
