<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

class ObjectPurgedInvocation extends Invocation
{
    public const TYPE = 'object-purged';

    public function __construct(private string $objectTitle, ObjectContext $context)
    {
        $this->context = $context;
    }

    public function getObjectTitle(): string
    {
        return $this->objectTitle;
    }

    public function __toString(): string
    {
        return 'Object is purged';
    }
}
