<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ButtonInvocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;

class ButtonInvocationMatcher extends DaoMatcher
{
    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof ButtonInvocation) {
            return [];
        }
        $conditions = ["JSON_UNQUOTE(JSON_EXTRACT(automation_trigger, \"$.type\")) = 'button'"];
        $flowId = $invocation->getAutomationId();

        if ($flowId !== null) {
            $conditions[] = "automation.id = " . $this->dao->convert_sql_text($flowId);
        }
        if ($group = $invocation->getGroupId()) {
            $conditions = ["JSON_SEARCH(automation_trigger, 'one', '{$group}', null, '$.group') is not null"];
        }
        return $conditions;
    }

    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof ButtonInvocation;
    }
}
