<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType;

use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class CategoryCreatedTriggerType extends CategoryTriggerType
{
    public function __construct(private ?array $category)
    {
    }

    public function getCategory(): ?array
    {
        return $this->category;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $errors = [];
        if (gettype($this->category) === 'array' && count($this->category) === 0) {
            $errors[] = new ValidationMessage([...$path, 'category'], 'LC__MODULE__SYNETICS_FLOWS__VALUE_REQUIRED');
        }

        return $errors;
    }
}
