<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto\Criteria;

use idoit\Module\SyneticsFlows\Dto\Criteria;

class QueryCriteria extends FieldCriteria
{
    public const PLACEHOLDER = '%PLACEHOLDER%';

    public function __construct(?string $field = null, private ?Criteria $criteria = null)
    {
        parent::__construct($field);
    }

    public function getCriteria(): ?Criteria
    {
        return $this->criteria;
    }

    public function prepareReportManagerCondition(): array
    {
        $property = $this->getProperty();

        return [
            [
                'category' => $this->getCategory(),
                'property' => $property,
                'comparison' => 'subcnd',
                'subcnd' => [
                    $property => [
                        [
                            'category' => 'C__CATG__GLOBAL',
                            'property' => 'C__CATG__GLOBAL-id',
                            'comparison' => 'in',
                            'value' => self::PLACEHOLDER,
                        ]
                    ],
                ],
            ],
        ];
    }
}