<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Dto\Criteria;

abstract class ValueCriteria extends FieldCriteria
{
    protected const COMPARISON_OPERATOR = '';

    public function __construct(?string $field = null, protected $value = null)
    {
        parent::__construct($field);
    }

    /**
     * @return string|number|null
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getComparisonOperator(): string
    {
        return static::COMPARISON_OPERATOR;
    }

    public function prepareReportManagerCondition(): array
    {
        return [
            [
                'category' => $this->getCategory(),
                'property' => $this->getProperty(),
                'comparison' => $this->getComparisonOperator(),
                'value' => $this->getValue(),
            ],
        ];
    }
}
