<?php

namespace idoit\Module\SyneticsFlows\Filter;

class AttributeDataFilter extends AttributeFilter
{
    /**
     * @var string|null
     */
    private ?string $entryId = null;

    /**
     * @param string      $id
     * @param string|null $entryId
     *
     * @return AttributeDataFilter
     */
    public static function factory(string $id, ?string $entryId = null): AttributeDataFilter
    {
        $filter = new self();
        [$category, $attribute] = explode('.', $id);

        $filter->setAttribute($attribute);
        $filter->setCategoryFilter($category);
        $filter->setEntryId($entryId);

        return $filter;
    }

    /**
     * @param string|null $entryId
     *
     * @return $this
     */
    public function setEntryId(?string $entryId): AttributeDataFilter
    {
        $this->entryId = $entryId;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getEntryId(): ?string
    {
        return $this->entryId;
    }
}
